#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <time.h>
#include <unistd.h>

#define AUTO 0
#define AUTOBUS 1
#define KAMION 2
#define PRAZAN 0
#define SMER_1 1
#define SMER_2 2

typedef struct vozilo
{
    int smerVozila;
    int tipVozila;
}Vozilo;

int automobil = 0;
int autobus = 0;
int kamion = 0;
int smer = 0;

pthread_mutex_t mutex;
pthread_cond_t cond;

void *prelazak(void *arg)
{
    sleep(rand()%10);

    int tipVozila = ((Vozilo *)arg)->tipVozila;
    int smerVozila = ((Vozilo *)arg)->smerVozila;

    if (tipVozila == AUTO)
    {
        pthread_mutex_lock(&mutex);

        while (kamion || (smer!=smerVozila && smer!=PRAZAN))
        {
            pthread_cond_wait(&cond, &mutex);
        }

        if (smer == PRAZAN)
        {
            smer = smerVozila;
        }

        automobil++;

        pthread_mutex_unlock(&mutex);

        printf("Vozilo tipa %d prelazi u smeru %d\n", tipVozila ,smerVozila);

        sleep(5);

        printf("Vozilo tipa %d preslo sa smera %d\n", tipVozila ,smerVozila);
    
        pthread_mutex_lock(&mutex);
        
        automobil--;
        if(automobil==0 && autobus == 0 && kamion == 0)
        {
            smer = PRAZAN;
            pthread_cond_broadcast(&cond);
        }
        pthread_mutex_unlock(&mutex);

    }
    else if (tipVozila == AUTOBUS)
    {
        pthread_mutex_lock(&mutex);

        while (kamion || autobus || (smer!=smerVozila && smer!=PRAZAN))
        {
            pthread_cond_wait(&cond, &mutex);
        }

        if (smer == PRAZAN)
        {
            smer = smerVozila;
        }

        autobus++;

        pthread_mutex_unlock(&mutex);

        printf("Vozilo tipa %d prelazi u smeru %d\n", tipVozila ,smerVozila);

        sleep(5);

        printf("Vozilo tipa %d preslo sa smera %d\n", tipVozila ,smerVozila);
    
        pthread_mutex_lock(&mutex);
        
        autobus--;
        if(automobil==0 && autobus == 0 && kamion == 0)
        {
            smer = PRAZAN;
            pthread_cond_broadcast(&cond);
        }
        pthread_mutex_unlock(&mutex);
    }
    else if (tipVozila == KAMION)
    {
        pthread_mutex_lock(&mutex);

        while (kamion || autobus || automobil || (smer!=smerVozila && smer!=PRAZAN))
        {
            pthread_cond_wait(&cond, &mutex);
        }

        if (smer == PRAZAN)
        {
            smer = smerVozila;
        }

        kamion++;

        pthread_mutex_unlock(&mutex);

        printf("Vozilo tipa %d prelazi u smeru %d\n", tipVozila ,smerVozila);

        sleep(5);

        printf("Vozilo tipa %d preslo sa smera %d\n", tipVozila ,smerVozila);
    
        pthread_mutex_lock(&mutex);
        
        kamion--;
        if(automobil==0 && autobus == 0 && kamion == 0)
        {
            smer = PRAZAN;
            pthread_cond_broadcast(&cond);
        }
        pthread_mutex_unlock(&mutex);
    }
    pthread_exit(NULL);
}

int main()
{
    pthread_mutex_init(&mutex, NULL);
    pthread_cond_init(&cond, NULL);

    pthread_t niti[10];
    int i;
    for (i=0; i<10; i++)
    {
        Vozilo *v = malloc(sizeof(Vozilo));
        v->tipVozila=rand()%3;
        v->smerVozila=rand()%2;
        pthread_create(&niti[i], NULL, prelazak, (void *)v);
    }

    for (i=0; i<10; i++)
    {
        pthread_join(niti[i], NULL);
    }

    pthread_exit(NULL);
    return 0;
}